/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoProvider;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MenuInfoRegistryImpl
implements MenuInfoRegistry {
    private final Map<CategoryIdentifier<?>, Map<Class<? extends AbstractContainerMenu>, List<MenuInfoProvider<?, ?>>>> map = Maps.newLinkedHashMap();
    private final Map<Predicate<CategoryIdentifier<?>>, List<MenuInfoProvider<?, ?>>> mapGeneric = Maps.newLinkedHashMap();

    @Override
    public <C extends AbstractContainerMenu, D extends Display> void register(CategoryIdentifier<D> category, Class<C> menuClass, MenuInfoProvider<C, D> menuInfo) {
        this.map.computeIfAbsent(category, id -> Maps.newLinkedHashMap()).computeIfAbsent(menuClass, c -> Lists.newArrayList()).add(menuInfo);
        InternalLogger.getInstance().debug("Added menu info for %s [%s]: %s", menuClass, category, menuInfo);
    }

    @Override
    public <D extends Display> void registerGeneric(final Predicate<CategoryIdentifier<?>> categoryPredicate, MenuInfoProvider<?, D> menuInfo) {
        this.mapGeneric.computeIfAbsent(new Predicate<CategoryIdentifier<?>>(){

            @Override
            public boolean test(CategoryIdentifier<?> categoryIdentifier) {
                return categoryPredicate.test(categoryIdentifier);
            }

            public int hashCode() {
                return System.identityHashCode(this);
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        }, id -> Lists.newArrayList()).add(menuInfo);
        InternalLogger.getInstance().debug("Added generic menu info for: %s", menuInfo);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <C extends AbstractContainerMenu, D extends Display> MenuInfo<C, D> getClient(D display, MenuSerializationContext<C, ?, D> context, C menu) {
        return this.getInternal(display.getCategoryIdentifier(), menu.getClass(), provider -> provider.provideClient(display, context, menu));
    }

    @Override
    @Nullable
    public <C extends AbstractContainerMenu, D extends Display> MenuInfo<C, D> get(CategoryIdentifier<D> category, C menu, MenuSerializationContext<C, ?, D> context, CompoundTag tag) {
        return this.getInternal(category, menu.getClass(), provider -> provider.provide(category, menu, context, tag));
    }

    private <C extends AbstractContainerMenu, D extends Display> MenuInfo<C, D> getInternal(CategoryIdentifier<D> category, Class<C> menuClass, Function<MenuInfoProvider<C, D>, Optional<MenuInfo<C, D>>> function) {
        Map<Class<AbstractContainerMenu>, List<MenuInfoProvider<?, ?>>> infoMap = this.map.get(category);
        if (infoMap != null && !infoMap.isEmpty()) {
            if (infoMap.containsKey(menuClass)) {
                for (MenuInfoProvider menuInfoProvider : infoMap.get(menuClass)) {
                    Optional<MenuInfo<C, D>> info = function.apply(menuInfoProvider);
                    if (!info.isPresent()) continue;
                    return info.get();
                }
            }
            for (Map.Entry entry : infoMap.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(menuClass)) continue;
                for (MenuInfoProvider provider : (List)entry.getValue()) {
                    Optional<MenuInfo<C, D>> info = function.apply(provider);
                    if (!info.isPresent()) continue;
                    return info.get();
                }
            }
        }
        for (Map.Entry<Predicate<CategoryIdentifier<?>>, List<MenuInfoProvider<?, ?>>> entry : this.mapGeneric.entrySet()) {
            Optional<MenuInfo<C, D>> info;
            List<MenuInfoProvider<?, ?>> infoList;
            if (!entry.getKey().test(category) || entry.getValue().isEmpty() || (infoList = entry.getValue()).isEmpty() || !(info = function.apply(infoList.get(0))).isPresent()) continue;
            return info.get();
        }
        return null;
    }

    @Override
    public int infoSize() {
        return this.map.size() + this.mapGeneric.size();
    }

    @Override
    public void startReload() {
        this.map.clear();
        this.mapGeneric.clear();
    }

    @Override
    public void endReload() {
        InternalLogger.getInstance().debug("Registered %d menu infos", this.infoSize());
    }

    @Override
    public void acceptPlugin(REIServerPlugin plugin) {
        plugin.registerMenuInfo(this);
    }
}

